package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "INSTITUTIONS")
public class Institutions implements Serializable {

	private static final long serialVersionUID = 5441323895933357372L;

	@Id
	@Column(name = "INSTITUTION_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "PARENT_INSTITUTION_ID")
	private Long parentInstitutionId;
	
	@Column(name = "VERSION")
	private Long versionNumber;
	
	@Column(name = "NAME")
	private String name;

	@Column(name = "VISTA_NAME")
	private String vistaName;

	@Column(name = "STATION_NUMBER")
	private String stationNumber;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "ARCHIVED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date archivedDate;

	@Column(name = "STREETCITY")
	private String city;
	
	@Column(name = "VISN_ID")
	private BigDecimal visnId;
	
	@Column(name = "FACILITYTYPE_ID")
	private BigDecimal facilitytypeId;
	
	@Column(name = "AGENCY_ID")
	private BigDecimal agencyId;
	
	@Column(name = "ACTIVATIONDATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date activationDate;
	
	@Column(name = "DEACTIVATIONDATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date deactivationDate;
	
	@Column(name = "FACILITY_PHONE_NUMBER")
	private String facilityPhoneNumber;
	
	@Column(name = "FACILITY_INTERNET_URL")
	private String facilityInternetUrl;
	
	@Column(name = "FACILITY_INTRANET_URL")
	private String facilityIntranetUrl;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getParentInstitutionId() {
		return parentInstitutionId;
	}

	public void setParentInstitutionId(Long parentInstitutionId) {
		this.parentInstitutionId = parentInstitutionId;
	}

	public Long getVersionNumber() {
		return versionNumber;
	}

	public void setVersionNumber(Long versionNumber) {
		this.versionNumber = versionNumber;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getVistaName() {
		return vistaName;
	}

	public void setVistaName(String vistaName) {
		this.vistaName = vistaName;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Date getArchivedDate() {
		return archivedDate;
	}

	public void setArchivedDate(Date archivedDate) {
		this.archivedDate = archivedDate;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public BigDecimal getVisnId() {
		return visnId;
	}

	public void setVisnId(BigDecimal visnId) {
		this.visnId = visnId;
	}

	public BigDecimal getFacilitytypeId() {
		return facilitytypeId;
	}

	public void setFacilitytypeId(BigDecimal facilitytypeId) {
		this.facilitytypeId = facilitytypeId;
	}

	public BigDecimal getAgencyId() {
		return agencyId;
	}

	public void setAgencyId(BigDecimal agencyId) {
		this.agencyId = agencyId;
	}

	public Date getActivationDate() {
		return activationDate;
	}

	public void setActivationDate(Date activationDate) {
		this.activationDate = activationDate;
	}

	public Date getDeactivationDate() {
		return deactivationDate;
	}

	public void setDeactivationDate(Date deactivationDate) {
		this.deactivationDate = deactivationDate;
	}

	public String getFacilityPhoneNumber() {
		return facilityPhoneNumber;
	}

	public void setFacilityPhoneNumber(String facilityPhoneNumber) {
		this.facilityPhoneNumber = facilityPhoneNumber;
	}

	public String getFacilityInternetUrl() {
		return facilityInternetUrl;
	}

	public void setFacilityInternetUrl(String facilityInternetUrl) {
		this.facilityInternetUrl = facilityInternetUrl;
	}

	public String getFacilityIntranetUrl() {
		return facilityIntranetUrl;
	}

	public void setFacilityIntranetUrl(String facilityIntranetUrl) {
		this.facilityIntranetUrl = facilityIntranetUrl;
	}
}
